function svgpolygon(fid, x, y, varargin)

% default values
stroke='none';
fill = 'red';
stroke_width=1;

% parameter handling
for argindex=1:2:length(varargin)
  arg=varargin{argindex};
  param=varargin{argindex+1};
  switch(arg)
   case 'stroke'
    stroke=param;
   case 'fill'
    fill=param;
   case 'stroke_width'
    stroke_width=param;
   otherwise
    error(['invalid parameter at position ', mat2str(argindex)]);
  end % switch
end % for argindex

% function body
if length(x) ~= length(y),
  error('need same length in x and y');
end

x = forcerow( x );
y = forcerow( y );

m=[x; y];
fprintf(fid, '<polygon points="');
fprintf(fid, '%f,%f ', m);
fprintf(fid, '" style="fill:%s;', fill);
fprintf(fid, 'stroke:%s;stroke-width:%i"/> \n' , stroke, stroke_width);
